(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14127,        482]*)
(*NotebookOutlinePosition[     15219,        519]*)
(*  CellTagsIndexPosition[     15131,        513]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["High Order Nonhomogeneous Equations: the Complete Solution", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sometimes does not solve linear problems of order greater than 4,\nwe \
must do these problems ourselves. The packages ",
  StyleBox["DKernel.m",
    FontWeight->"Bold"],
  " and ",
  StyleBox["VarPar.m",
    FontWeight->"Bold"],
  " are provided to find the Kernel of an operator, and, using this Kernel, \
to find a particular solution by Variation of Parameters. If we have these \
two things we can produce the complete solution. Of course, having the \
complete solution lets us solve all of the solvable forms of initial or \
boundary value problems.\n\nThis notebook requires ",
  StyleBox["DKernel.m",
    FontWeight->"Bold"],
  " and ",
  StyleBox["VarPar.m",
    FontWeight->"Bold"],
  " to be available; it attempts to load them if they are not already \
loaded."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The Process"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[x, y, y1, y2, r]\)], "Input"],

Cell[CellGroupData[{

Cell[TextData["Get an operator"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[r_] = Expand[\((r - 2)\)\ \((r - 3)\)]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(6 - 5\ r + r\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[x, y, L]\), "\n", 
    \(L[x_, y_] = MakeOperator[p, r, x, y]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(6\ y[x]\), "-", 
      RowBox[{"5", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Use DKernel to find the Kernel of the operator"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<DKernel\>", LongForm \[Rule] False]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \("DKernel[eqn,y[x],x] finds a kernel for a single constant coefficients \
homogeneous linear differential equation eqn. The parameters have the same \
form as those of DSolve."\)], "Print",
  CellTags->"Info3306933997-4542859"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(basis = DKernel[L[x, y] == 0, y[x], x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(2\ x\), \[ExponentialE]\^\(3\ x\)}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Use this basis and Variation of Parameters to get a particular solution"], 
  "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "For our example use ",
  StyleBox["y''[x]-5y'[x]+6y[]x==6x", "Input"],
  ": "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(yp[x_] = VarPar[basis, 6\ x, x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(5\/6 + x\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The complete solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Having a basis for the kernel and a particular solution gives us the \
complete solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(solution[x_] = 
      basis . Table[C[i], {i, Length[basis]}] + yp[x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(5\/6 + 
      x + \[ExponentialE]\^\(2\ x\)\ C[1] + \[ExponentialE]\^\(3\ x\)\ C[
          2]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initial/Boundary Conditions"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Initial conditions"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"The solution we have obtained is a description of every solution which the \
differential equation has. If there are initial or boundary conditions, we \
can easily impose them. For example, suppose we have the initial conditions \
y[0]=2,y'[0]=-3:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(solution[x]\), "/.", 
      RowBox[{
        RowBox[{"Solve", "[", 
          RowBox[{"{", 
            RowBox[{\(solution[0] == 2\), ",", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["solution", "\[Prime]",
                    MultilineFunction->None], "[", "0", "]"}], 
                "==", \(-3\)}]}], "}"}], "]"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(5\/6 + \(15\ \[ExponentialE]\^\(2\ x\)\)\/2 - \(19\ \
\[ExponentialE]\^\(3\ x\)\)\/3 + x\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Boundary conditions"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"It's that easy.  Suppose we had the boundary conditions y[0]=2,y[5]=-3:"], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[x_] = 
      solution[x] /. \(Solve[{solution[0] == 2, 
              solution[5] == \(-3\)}, {C[1], 
              C[2]}]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(5\/6 - \(\[ExponentialE]\^\(\(-10\) + 3\ x\)\ \((53 + 7\ \
\[ExponentialE]\^10)\)\)\/\(6\ \((\(-1\) + \[ExponentialE]\^5)\)\) - \(\
\[ExponentialE]\^\(\(-10\) + 2\ x\)\ \((\(-53\) - 7\ \[ExponentialE]\^15)\)\)\
\/\(6\ \((\(-1\) + \[ExponentialE]\^5)\)\) + x\)], "Output"]
}, Closed]],

Cell[TextData[
"This is ugly, as the solutions of boundary value problems often are, but it \
checks:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, y2] == 6\ x && y2[0] == 2 && y2[5] == \(-3\)]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Automate the process"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"We start with a differential equation, decompose it into its operator part \
and its nonhomogeneous part, and then do what we did above. That's it."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{\(Clear[FormalDSolve, x, y]\), "\n", 
    RowBox[{\(FormalDSolve[eqn_, dVar_, iVar_?AtomQ]\), ":=", 
      RowBox[{"Module", "[", 
        RowBox[{\({operator, nonhomogeneousPart, rhs, basis, i, adjust, 
            particular, dVarName = Head[dVar]}\), ",", 
          RowBox[{
            RowBox[{"nonhomogeneousPart", "=", 
              RowBox[{"eqn", "/.", 
                RowBox[{"{", 
                  RowBox[{\(dVarName[iVar] \[Rule] 0\), ",", 
                    RowBox[{
                      RowBox[{
                        SuperscriptBox["dVarName", 
                          TagBox[\((pwr_)\),
                            Derivative],
                          MultilineFunction->None], "[", "iVar", "]"}], 
                      "\[Rule]", "0"}]}], "}"}]}]}], 
            ";", \(rhs = nonhomogeneousPart /. q1_ == q2_ \[Rule] q2 - q1\), 
            ";", \(operator = \
\((eqn\[LeftDoubleBracket]1\[RightDoubleBracket] - 
                    nonhomogeneousPart\[LeftDoubleBracket]1\
\[RightDoubleBracket])\) - \((eqn\[LeftDoubleBracket]2\[RightDoubleBracket] - 
                    nonhomogeneousPart\[LeftDoubleBracket]2\
\[RightDoubleBracket])\)\), 
            ";", \(basis = DKernel[operator == 0, dVarName[iVar], iVar]\), 
            ";", 
            RowBox[{"adjust", "=", 
              RowBox[{"Coefficient", "[", 
                RowBox[{"operator", ",", 
                  RowBox[{
                    SuperscriptBox["dVarName", 
                      TagBox[\((Length[basis])\),
                        Derivative],
                      MultilineFunction->None], "[", "iVar", "]"}]}], "]"}]}],
             ";", \(particular = VarPar[basis, rhs\/adjust, iVar]\), 
            ";", \(Clear[c]\), 
            ";", \(basis . Table[c[i], {i, Length[basis]}] + particular\)}]}],
         "]"}]}]}], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples of Use"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Example 1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here is the problem we did above:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormalDSolve[L[x, y] == 6\ x, y[x], x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(5\/6 + 
      x + \[ExponentialE]\^\(2\ x\)\ c[1] + \[ExponentialE]\^\(3\ x\)\ c[
          2]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 2"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Here is a problem having r==2 as a double root of the characteristic \
equation, where the right hand side needs to be adjusted:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FormalDSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{"3", " ", 
            RowBox[{
              SuperscriptBox["y", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "==", 
          RowBox[{\(18\ x\), "-", 
            RowBox[{"12", " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], 
            "-", \(12\ y[x]\)}]}], ",", \(y[x]\), ",", "x"}], "]"}]], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    \(3\/2\ \((\(-1\) + x)\) + \[ExponentialE]\^\(\(-2\)\ x\)\ c[
          1] + \[ExponentialE]\^\(\(-2\)\ x\)\ x\ c[2]\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["For further thought"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Consider how to extend the above function ",
  StyleBox["FormalDSolve",
    FontWeight->"Bold"],
  " to include initial/boundary conditions.  Work out the details.  The \
difficulty lies in separating the differential equation from the \
initial/boundary conditions."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initialization"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    RowBox[{\(Clear[MakeOperator, x, y]\), "\[IndentingNewLine]"}], "\n", 
    RowBox[{\(Off[RuleDelayed::"\<rhs\>"]\), "\[IndentingNewLine]"}], "\n", 
    RowBox[{
      RowBox[{\(MakeOperator[p_, r_, x_, y_]\), ":=", 
        RowBox[{"Module", "[", 
          RowBox[{\({q = p[r] - p[0]}\), ",", 
            RowBox[{\(q + p[0]\ y[x]\), "/.", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"r", "\[Rule]", 
                    RowBox[{
                      SuperscriptBox["y", "\[Prime]",
                        MultilineFunction->None], "[", "x", "]"}]}], ",", 
                  RowBox[{\(r\^p_\), "\[Rule]", 
                    RowBox[{
                      SuperscriptBox["y", 
                        TagBox[\((p)\),
                          Derivative],
                        MultilineFunction->None], "[", "x", "]"}]}]}], 
                "}"}]}]}], "]"}]}], "\[IndentingNewLine]"}], "\n", \(On[
      RuleDelayed::"\<rhs\>"]\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(<< "\<~/Library/Mathematica/Applications/RossDE/DKernel.m\>"\)], "Input"],

Cell[BoxData[
    \(<< "\<~/Library/Mathematica/Applications/RossDE/VarPar.m\>"\)], "Input"],

Cell[BoxData[
    \(Off[$MaxExtraPrecision::"\<meprec\>"]\)], "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{580, 364},
WindowMargins->{{44, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3306933997-4542859"->{
    Cell[4098, 140, 246, 4, 55, "Print",
      CellTags->"Info3306933997-4542859"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3306933997-4542859", 15021, 506}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 127, 2, 95, "Subtitle",
  Evaluatable->False],
Cell[1906, 57, 919, 25, 158, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2850, 86, 89, 2, 56, "Section",
  Evaluatable->False],
Cell[2942, 90, 55, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[3022, 95, 96, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3143, 101, 100, 2, 27, "Input"],
Cell[3246, 105, 49, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3332, 111, 129, 3, 43, "Input"],
Cell[3464, 116, 320, 8, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3833, 130, 127, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3985, 136, 110, 2, 27, "Input"],
Cell[4098, 140, 246, 4, 55, "Print",
  CellTags->"Info3306933997-4542859"]
}, Closed]],

Cell[CellGroupData[{
Cell[4381, 149, 98, 2, 27, "Input"],
Cell[4482, 153, 88, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4619, 160, 156, 4, 46, "Subsection",
  Evaluatable->False],
Cell[4778, 166, 157, 6, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4960, 176, 91, 2, 27, "Input"],
Cell[5054, 180, 42, 1, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5145, 187, 102, 2, 46, "Subsection",
  Evaluatable->False],
Cell[5250, 191, 165, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5440, 199, 129, 3, 27, "Input"],
Cell[5572, 204, 128, 3, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5749, 213, 108, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5882, 219, 102, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[5987, 223, 324, 6, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6336, 233, 488, 12, 27, "Input"],
Cell[6827, 247, 122, 2, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6998, 255, 103, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[7104, 259, 150, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7279, 267, 229, 5, 59, "Input"],
Cell[7511, 274, 291, 4, 47, "Output"]
}, Closed]],
Cell[7817, 281, 161, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8003, 289, 121, 3, 27, "Input"],
Cell[8127, 294, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8238, 303, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[8339, 307, 226, 5, 50, "Text",
  Evaluatable->False],
Cell[8568, 314, 1878, 38, 255, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[10483, 357, 93, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10601, 363, 90, 2, 46, "Subsection",
  Evaluatable->False],
Cell[10694, 367, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10827, 373, 98, 2, 27, "Input"],
Cell[10928, 377, 128, 3, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11105, 386, 90, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11198, 390, 204, 4, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11427, 398, 559, 15, 27, "Input"],
Cell[11989, 415, 148, 2, 42, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12198, 424, 97, 2, 36, "Section",
  Evaluatable->False],
Cell[12298, 428, 347, 9, 68, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[12682, 442, 92, 2, 36, "Section",
  Evaluatable->False],
Cell[12777, 446, 1058, 23, 163, "Input",
  InitializationCell->True],
Cell[13838, 471, 93, 1, 27, "Input"],
Cell[13934, 474, 92, 1, 27, "Input"],
Cell[14029, 477, 70, 1, 27, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

